#!/bin/sh
#
# $Header: opsm/cvutl/pluggable/unix/css_misscount.sh /main/3 2012/03/28 22:15:01 ptare Exp $
#
# css_misscount.sh
#
# Copyright (c) 2010, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      css_misscount.sh - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    ptare       03/22/12 - Bug#13839554 Change the default expected value of CSS misscount
#                           from 60 to 30 based on current version of crs
#    nvira       08/11/10 - pluggable script to check css misscount settings
#    nvira       08/09/10 - pluggable script for css misscount
#    nvira       08/09/10 - Creation
#

SCAT="/bin/cat"
SGREP="/bin/grep"

CRS_HOME=$1
CRS_ACTIVE_VERSION=$2

PLATFORM=`/bin/uname`

case $PLATFORM in
  Linux)
      #the expected css misscount varies by current version of crs, mainly between release 10 and 11 or further, hence set it accordingly
      if [[ $CRS_ACTIVE_VERSION == 10* ]]
      then 
       expected=60
      else
       expected=30
      fi
      _HOST=`/bin/hostname`
  ;;
  SunOS | HP-UX | AIX)
      expected=30
      _HOST=`/usr/bin/hostname`
  ;;
esac

# Set default exit message to indicate failure.
result="<RESULT>EFAIL</RESULT><EXPECTED>$expected</EXPECTED><EXEC_ERROR>Error while CSS misscount settings</EXEC_ERROR><TRACE>Unable to get the CSS misscount settings on the sytem</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>0254</ID><MSG_DATA><DATA>$_HOST</DATA></MSG_DATA></NLS_MSG>"
existstatus=3

command="$CRS_HOME/bin/crsctl get css misscount"
css_misscount=$(/bin/sh -c "$command")
ret=$?

if [ $ret -eq 0 ]
then
  command="echo "$css_misscount" | sed 's/CRS-4678:\([^0-9]*\)\([0-9]*\)\(.*\)/\2/'"
  css_misscount=$(/bin/sh -c "$command")

  if [ $css_misscount -ge $expected ]
  then
    result="<RESULT>SUCC</RESULT><COLLECTED>$css_misscount</COLLECTED><EXPECTED>$expected</EXPECTED><TRACE>CSS misscount is not set to recommended value of $expected on node $_HOST</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>0252</ID><MSG_DATA><DATA>$_HOST</DATA></MSG_DATA></NLS_MSG>"
    existstatus=0
  else
    result="<RESULT>VFAIL</RESULT><COLLECTED>$css_misscount</COLLECTED><EXPECTED>$expected</EXPECTED><TRACE>CSS misscount is set to recommended value of $expected on $_HOST</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>0253</ID><MSG_DATA><DATA>$_HOST</DATA></MSG_DATA></NLS_MSG>"
    existstatus=2
  fi   
else
  result="<RESULT>VFAIL</RESULT><COLLECTED>NOT SET</COLLECTED><EXPECTED>$expected</EXPECTED><TRACE>CSS misscount is set to recommended value of $expected on $_HOST</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>0253</ID><MSG_DATA><DATA>$_HOST</DATA></MSG_DATA></NLS_MSG>"
  existstatus=2
fi   

echo $result
exit $existstatus
